//----------------------------------------------------------------------------//
//- CadEtikettenDrucken.pas --------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Zeigt einen Dialog an, bei dem man whlen kann, ob beim Etikettendrucken   //
// ein neuer Etikettenbogen oder ein bestehender verwendet werden soll.       //
//----------------------------------------------------------------------------//

unit CadEtikettenDrucken;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, CaoRegistry;

//------------------------------------------------------------------------------

type
  TCaDlgEtikettenDrucken = class(TForm)
    m_BtnNeuerBogen            : TBitBtn;
    m_BtnAngefangenerBogen     : TBitBtn;
    m_BtnBenutzerdefiniert     : TBitBtn;
    m_BtnSchliessen            : TButton;

    //--------------------------------------------------------------------------

    procedure BtnBenutzerdefiniertClick  (Sender: TObject);
    procedure BtnAngefangenerBogenClick  (Sender: TObject);
    procedure BtnNeuerBogenClick         (Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

  //----------------------------------------------------------------------------

  private
    m_iModalResult: Integer;   

  //----------------------------------------------------------------------------

  public

  //----------------------------------------------------------------------------
   
  end; // TCaDlgEtikettenDrucken

//------------------------------------------------------------------------------

var
  CaDlgEtikettenDrucken: TCaDlgEtikettenDrucken;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CadAnzahlEtiketten, CamConst;

//------------------------------------------------------------------------------

procedure TCaDlgEtikettenDrucken.BtnBenutzerdefiniertClick(Sender: TObject);
begin
  m_iModalResult := c_iDailogResultAnzahlEingeben;
  close;
end; // TCaDlgEtikettenDrucken.BtnBenutzerdefiniertClick

//------------------------------------------------------------------------------

procedure TCaDlgEtikettenDrucken.BtnAngefangenerBogenClick(Sender: TObject);
begin
  m_iModalResult := c_iDialogResultBogenFortfahren;
  close;
end; // TCaDlgEtikettenDrucken.BtnAngefangenerBogenClick

//------------------------------------------------------------------------------

procedure TCaDlgEtikettenDrucken.BtnNeuerBogenClick(Sender: TObject);
begin
  m_iModalResult := c_iDialogResultNeuerBogen;
  close;
end; // TCaDlgEtikettenDrucken.BtnNeuerBogenClick

//------------------------------------------------------------------------------

procedure TCaDlgEtikettenDrucken.FormClose(Sender    : TObject;
                                           var Action: TCloseAction);
begin
  if ModalResult <> mrAbort then begin
    ModalResult := m_iModalResult;
  end; // ir
end; // TCaDlgEtikettenDrucken.FormClose

//------------------------------------------------------------------------------

end. // CadEtikettenDrucken
